/*
 * Decompiled with CFR 0.152.
 */
package io.sigpipe.jbsdiff.ui;

import io.sigpipe.jbsdiff.DefaultDiffSettings;
import io.sigpipe.jbsdiff.Diff;
import io.sigpipe.jbsdiff.InvalidHeaderException;
import io.sigpipe.jbsdiff.Patch;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.compress.compressors.CompressorException;

public class FileUI {
    private FileUI() {
    }

    public static void diff(File oldFile, File newFile, File patchFile) throws CompressorException, InvalidHeaderException, IOException {
        FileUI.diff(oldFile, newFile, patchFile, "bzip2");
    }

    public static void diff(File oldFile, File newFile, File patchFile, String compression) throws CompressorException, InvalidHeaderException, IOException {
        FileInputStream oldIn = new FileInputStream(oldFile);
        byte[] oldBytes = new byte[(int)oldFile.length()];
        oldIn.read(oldBytes);
        oldIn.close();
        FileInputStream newIn = new FileInputStream(newFile);
        byte[] newBytes = new byte[(int)newFile.length()];
        newIn.read(newBytes);
        newIn.close();
        FileOutputStream out = new FileOutputStream(patchFile);
        DefaultDiffSettings settings = new DefaultDiffSettings(compression);
        Diff.diff(oldBytes, newBytes, out, settings);
        out.close();
    }

    public static void patch(File oldFile, File newFile, File patchFile) throws CompressorException, InvalidHeaderException, IOException {
        Patch.patch(oldFile, newFile, patchFile);
    }
}

